using System;
using System.IO; // Required for file I/O
using System.Text; // Required for Encoding command
using System.Windows.Forms; //required for message box


namespace FileManager
{
	/// <summary>
	/// Save swipe data to file
	/// </summary>
	public class FileStore
	{


		private static string  StrDirName = @"\Tokenworks\";	// Directory where transaction file is
		private static string  StrFileName = @"RawData.txt";	// Holds swipes strings

		public static void WriteString2File(string StrSwipeData)
		{

			if (! Directory.Exists(StrDirName))
			{
				Directory.CreateDirectory(StrDirName);
			}

			if (! File.Exists(StrDirName+StrFileName))
			{	
				// Create the file and then make sure it is closed so StreamWrite can re-open it. 
				File.Create(StrDirName+StrFileName).Close();
			}
									
			if ( File.Exists(StrDirName+StrFileName))
			{
				//	File.Delete(StrDirName+StrFileName);// Delete the file as it 
				// Create Writer
				StreamWriter swrtFile = File.AppendText(StrDirName+StrFileName);
				// Position make data write out to SD card after each write command
				swrtFile.AutoFlush = true;
				// Write the file
				swrtFile.WriteLine(StrSwipeData);
//				swrtFile.WriteLine(DateTime.Now);
				// Write End of File so when reading the file, an exception for reading beyond the end of file isn't thrown 
				// Close the file
				swrtFile.Close();
			}
			else
			{
                MessageBox.Show("Problem creating C:Tokenworks\\RawData.txt");
			}
			
		}


	}
}
